@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectionPool Connection pool information for the listener.
 * @property healthCheck Health check information for the listener.
 * @property portMapping Port mapping information for the listener.
 * @property tls Transport Layer Security (TLS) properties for the listener
 */
public data class VirtualGatewaySpecListenerArgs(
    public val connectionPool: Output<VirtualGatewaySpecListenerConnectionPoolArgs>? = null,
    public val healthCheck: Output<VirtualGatewaySpecListenerHealthCheckArgs>? = null,
    public val portMapping: Output<VirtualGatewaySpecListenerPortMappingArgs>,
    public val tls: Output<VirtualGatewaySpecListenerTlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerArgs.builder()
            .connectionPool(connectionPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portMapping(portMapping.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerArgsBuilder internal constructor() {
    private var connectionPool: Output<VirtualGatewaySpecListenerConnectionPoolArgs>? = null

    private var healthCheck: Output<VirtualGatewaySpecListenerHealthCheckArgs>? = null

    private var portMapping: Output<VirtualGatewaySpecListenerPortMappingArgs>? = null

    private var tls: Output<VirtualGatewaySpecListenerTlsArgs>? = null

    /**
     * @param value Connection pool information for the listener.
     */
    @JvmName("hgcvkcyomrngygyd")
    public suspend fun connectionPool(`value`: Output<VirtualGatewaySpecListenerConnectionPoolArgs>) {
        this.connectionPool = value
    }

    /**
     * @param value Health check information for the listener.
     */
    @JvmName("xvusrnnntwxcmxau")
    public suspend fun healthCheck(`value`: Output<VirtualGatewaySpecListenerHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("camxfgibghuffiiu")
    public suspend fun portMapping(`value`: Output<VirtualGatewaySpecListenerPortMappingArgs>) {
        this.portMapping = value
    }

    /**
     * @param value Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("tpucfipjvbybmjwf")
    public suspend fun tls(`value`: Output<VirtualGatewaySpecListenerTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value Connection pool information for the listener.
     */
    @JvmName("rpifwgwtxshjbokm")
    public suspend fun connectionPool(`value`: VirtualGatewaySpecListenerConnectionPoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionPool = mapped
    }

    /**
     * @param argument Connection pool information for the listener.
     */
    @JvmName("aglxggpoobxgbiwr")
    public suspend fun connectionPool(argument: suspend VirtualGatewaySpecListenerConnectionPoolArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerConnectionPoolArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionPool = mapped
    }

    /**
     * @param value Health check information for the listener.
     */
    @JvmName("oonsmuwtokqkolgm")
    public suspend fun healthCheck(`value`: VirtualGatewaySpecListenerHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument Health check information for the listener.
     */
    @JvmName("wdxobqvkdaxkhcou")
    public suspend fun healthCheck(argument: suspend VirtualGatewaySpecListenerHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerHealthCheckArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value Port mapping information for the listener.
     */
    @JvmName("ndvysuaecqqnoeuh")
    public suspend fun portMapping(`value`: VirtualGatewaySpecListenerPortMappingArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portMapping = mapped
    }

    /**
     * @param argument Port mapping information for the listener.
     */
    @JvmName("admjtfnugvwhmmnr")
    public suspend fun portMapping(argument: suspend VirtualGatewaySpecListenerPortMappingArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerPortMappingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.portMapping = mapped
    }

    /**
     * @param value Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("bdxekrxijiadufea")
    public suspend fun tls(`value`: VirtualGatewaySpecListenerTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Transport Layer Security (TLS) properties for the listener
     */
    @JvmName("xbkcspifjdxpuswh")
    public suspend fun tls(argument: suspend VirtualGatewaySpecListenerTlsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerArgs = VirtualGatewaySpecListenerArgs(
        connectionPool = connectionPool,
        healthCheck = healthCheck,
        portMapping = portMapping ?: throw PulumiNullFieldException("portMapping"),
        tls = tls,
    )
}
