@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolGrpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
 */
public data class VirtualGatewaySpecListenerConnectionPoolGrpcArgs(
    public val maxRequests: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolGrpcArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolGrpcArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolGrpcArgs.builder()
            .maxRequests(maxRequests.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerConnectionPoolGrpcArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerConnectionPoolGrpcArgsBuilder internal constructor() {
    private var maxRequests: Output<Int>? = null

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("jbrsfnijvmbuyxfe")
    public suspend fun maxRequests(`value`: Output<Int>) {
        this.maxRequests = value
    }

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("ybaiyqibbyaiykob")
    public suspend fun maxRequests(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRequests = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerConnectionPoolGrpcArgs =
        VirtualGatewaySpecListenerConnectionPoolGrpcArgs(
            maxRequests = maxRequests ?: throw PulumiNullFieldException("maxRequests"),
        )
}
