@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttp2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
 */
public data class VirtualGatewaySpecListenerConnectionPoolHttp2Args(
    public val maxRequests: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttp2Args> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttp2Args =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttp2Args.builder()
            .maxRequests(maxRequests.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerConnectionPoolHttp2Args].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerConnectionPoolHttp2ArgsBuilder internal constructor() {
    private var maxRequests: Output<Int>? = null

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("syliqegbqprwdyto")
    public suspend fun maxRequests(`value`: Output<Int>) {
        this.maxRequests = value
    }

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("evdtgsiufmjeqfve")
    public suspend fun maxRequests(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRequests = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerConnectionPoolHttp2Args =
        VirtualGatewaySpecListenerConnectionPoolHttp2Args(
            maxRequests = maxRequests ?: throw PulumiNullFieldException("maxRequests"),
        )
}
