@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
 * @property maxPendingRequests Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster. Minimum value of `1`.
 */
public data class VirtualGatewaySpecListenerConnectionPoolHttpArgs(
    public val maxConnections: Output<Int>,
    public val maxPendingRequests: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttpArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttpArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerConnectionPoolHttpArgs.builder()
            .maxConnections(maxConnections.applyValue({ args0 -> args0 }))
            .maxPendingRequests(maxPendingRequests?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerConnectionPoolHttpArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerConnectionPoolHttpArgsBuilder internal constructor() {
    private var maxConnections: Output<Int>? = null

    private var maxPendingRequests: Output<Int>? = null

    /**
     * @param value Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("mrpkjlawqxbvwomh")
    public suspend fun maxConnections(`value`: Output<Int>) {
        this.maxConnections = value
    }

    /**
     * @param value Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster. Minimum value of `1`.
     */
    @JvmName("rycucjpuhsrtxwog")
    public suspend fun maxPendingRequests(`value`: Output<Int>) {
        this.maxPendingRequests = value
    }

    /**
     * @param value Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("slleapilxygtqake")
    public suspend fun maxConnections(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxConnections = mapped
    }

    /**
     * @param value Number of overflowing requests after `max_connections` Envoy will queue to upstream cluster. Minimum value of `1`.
     */
    @JvmName("jwmrfelwxfhthchw")
    public suspend fun maxPendingRequests(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPendingRequests = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerConnectionPoolHttpArgs =
        VirtualGatewaySpecListenerConnectionPoolHttpArgs(
            maxConnections = maxConnections ?: throw PulumiNullFieldException("maxConnections"),
            maxPendingRequests = maxPendingRequests,
        )
}
