@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerPortMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port Port used for the port mapping.
 * @property protocol Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
 */
public data class VirtualGatewaySpecListenerPortMappingArgs(
    public val port: Output<Int>,
    public val protocol: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerPortMappingArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerPortMappingArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerPortMappingArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerPortMappingArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerPortMappingArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value Port used for the port mapping.
     */
    @JvmName("hpbggvvotrgadbhm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("usqkmrwovjjakjju")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Port used for the port mapping.
     */
    @JvmName("yusrqnsuwnssyprq")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol used for the port mapping. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("txjxchhojolaxlfo")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerPortMappingArgs =
        VirtualGatewaySpecListenerPortMappingArgs(
            port = port ?: throw PulumiNullFieldException("port"),
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        )
}
