@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property mode Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualGatewaySpecListenerTlsArgs(
    public val certificate: Output<VirtualGatewaySpecListenerTlsCertificateArgs>,
    public val mode: Output<String>,
    public val validation: Output<VirtualGatewaySpecListenerTlsValidationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsArgs.builder()
            .certificate(certificate.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .validation(validation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsArgsBuilder internal constructor() {
    private var certificate: Output<VirtualGatewaySpecListenerTlsCertificateArgs>? = null

    private var mode: Output<String>? = null

    private var validation: Output<VirtualGatewaySpecListenerTlsValidationArgs>? = null

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("uqjestdhbwdephgi")
    public suspend fun certificate(`value`: Output<VirtualGatewaySpecListenerTlsCertificateArgs>) {
        this.certificate = value
    }

    /**
     * @param value Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
     */
    @JvmName("jrovgnourlpdtlfd")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("tvtjgulwufsnyxoy")
    public suspend fun validation(`value`: Output<VirtualGatewaySpecListenerTlsValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("sjdooihokkbsbypc")
    public suspend fun certificate(`value`: VirtualGatewaySpecListenerTlsCertificateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Listener's TLS certificate.
     */
    @JvmName("yuvgqayrkwbtwipl")
    public suspend fun certificate(argument: suspend VirtualGatewaySpecListenerTlsCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsCertificateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
     */
    @JvmName("tjeiydhpivdopvgr")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("bqmphnagiqtxskjb")
    public suspend fun validation(`value`: VirtualGatewaySpecListenerTlsValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("xibadpjyavualicr")
    public suspend fun validation(argument: suspend VirtualGatewaySpecListenerTlsValidationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsValidationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsArgs = VirtualGatewaySpecListenerTlsArgs(
        certificate = certificate ?: throw PulumiNullFieldException("certificate"),
        mode = mode ?: throw PulumiNullFieldException("mode"),
        validation = validation,
    )
}
