@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acm An AWS Certificate Manager (ACM) certificate.
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecListenerTlsCertificateArgs(
    public val acm: Output<VirtualGatewaySpecListenerTlsCertificateAcmArgs>? = null,
    public val `file`: Output<VirtualGatewaySpecListenerTlsCertificateFileArgs>? = null,
    public val sds: Output<VirtualGatewaySpecListenerTlsCertificateSdsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateArgs = com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsCertificateArgs.builder()
        .acm(acm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsCertificateArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsCertificateArgsBuilder internal constructor() {
    private var acm: Output<VirtualGatewaySpecListenerTlsCertificateAcmArgs>? = null

    private var `file`: Output<VirtualGatewaySpecListenerTlsCertificateFileArgs>? = null

    private var sds: Output<VirtualGatewaySpecListenerTlsCertificateSdsArgs>? = null

    /**
     * @param value An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("pogdaaekksgfihyu")
    public suspend fun acm(`value`: Output<VirtualGatewaySpecListenerTlsCertificateAcmArgs>) {
        this.acm = value
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("fhidkxspffilgral")
    public suspend fun `file`(`value`: Output<VirtualGatewaySpecListenerTlsCertificateFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("jsrdgynfhdwjcitc")
    public suspend fun sds(`value`: Output<VirtualGatewaySpecListenerTlsCertificateSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("hfnyljfobgtccuqd")
    public suspend fun acm(`value`: VirtualGatewaySpecListenerTlsCertificateAcmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param argument An AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("aikjvlcvujkqbkdh")
    public suspend fun acm(argument: suspend VirtualGatewaySpecListenerTlsCertificateAcmArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsCertificateAcmArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.acm = mapped
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("rrnkxoqsqxijfhmj")
    public suspend fun `file`(`value`: VirtualGatewaySpecListenerTlsCertificateFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument Local file certificate.
     */
    @JvmName("wrmbofikgrcuhrmi")
    public suspend fun `file`(argument: suspend VirtualGatewaySpecListenerTlsCertificateFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsCertificateFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ndeddykphknvpuna")
    public suspend fun sds(`value`: VirtualGatewaySpecListenerTlsCertificateSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("dnptryyfaejknyxe")
    public suspend fun sds(argument: suspend VirtualGatewaySpecListenerTlsCertificateSdsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsCertificateSdsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsCertificateArgs =
        VirtualGatewaySpecListenerTlsCertificateArgs(
            acm = acm,
            `file` = `file`,
            sds = sds,
        )
}
