@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property subjectAlternativeNames SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualGatewaySpecListenerTlsValidationArgs(
    public val subjectAlternativeNames: Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs>? = null,
    public val trust: Output<VirtualGatewaySpecListenerTlsValidationTrustArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trust(trust.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsValidationArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsValidationArgsBuilder internal constructor() {
    private var subjectAlternativeNames:
        Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs>? = null

    private var trust: Output<VirtualGatewaySpecListenerTlsValidationTrustArgs>? = null

    /**
     * @param value SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("ntdjtjcfcnhnnorh")
    public suspend fun subjectAlternativeNames(`value`: Output<VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs>) {
        this.subjectAlternativeNames = value
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("dmeoxihepsslmchq")
    public suspend fun trust(`value`: Output<VirtualGatewaySpecListenerTlsValidationTrustArgs>) {
        this.trust = value
    }

    /**
     * @param value SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("ofeuqhicdrydwukd")
    public suspend fun subjectAlternativeNames(`value`: VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param argument SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("xqdrlegdnbvpuksj")
    public suspend fun subjectAlternativeNames(argument: suspend VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualGatewaySpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("qogewetuaenmtaxb")
    public suspend fun trust(`value`: VirtualGatewaySpecListenerTlsValidationTrustArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trust = mapped
    }

    /**
     * @param argument TLS validation context trust.
     */
    @JvmName("uocndxfemqlxiyfr")
    public suspend fun trust(argument: suspend VirtualGatewaySpecListenerTlsValidationTrustArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsValidationTrustArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trust = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsValidationArgs =
        VirtualGatewaySpecListenerTlsValidationArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            trust = trust ?: throw PulumiNullFieldException("trust"),
        )
}
