@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualGatewaySpecListenerTlsValidationTrustArgs(
    public val `file`: Output<VirtualGatewaySpecListenerTlsValidationTrustFileArgs>? = null,
    public val sds: Output<VirtualGatewaySpecListenerTlsValidationTrustSdsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsValidationTrustArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsValidationTrustArgsBuilder internal constructor() {
    private var `file`: Output<VirtualGatewaySpecListenerTlsValidationTrustFileArgs>? = null

    private var sds: Output<VirtualGatewaySpecListenerTlsValidationTrustSdsArgs>? = null

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("jxswmcdhkuytowut")
    public suspend fun `file`(`value`: Output<VirtualGatewaySpecListenerTlsValidationTrustFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("qhwhgkmlliscyibk")
    public suspend fun sds(`value`: Output<VirtualGatewaySpecListenerTlsValidationTrustSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("piwpgflqciettwyl")
    public suspend fun `file`(`value`: VirtualGatewaySpecListenerTlsValidationTrustFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument TLS validation context trust for a local file certificate.
     */
    @JvmName("pejtmmpthvupovnk")
    public suspend fun `file`(argument: suspend VirtualGatewaySpecListenerTlsValidationTrustFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsValidationTrustFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ugcfqcxkrbceroll")
    public suspend fun sds(`value`: VirtualGatewaySpecListenerTlsValidationTrustSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ebunenhpgbytfqmt")
    public suspend fun sds(argument: suspend VirtualGatewaySpecListenerTlsValidationTrustSdsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecListenerTlsValidationTrustSdsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsValidationTrustArgs =
        VirtualGatewaySpecListenerTlsValidationTrustArgs(
            `file` = `file`,
            sds = sds,
        )
}
