@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateChain Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
 */
public data class VirtualGatewaySpecListenerTlsValidationTrustFileArgs(
    public val certificateChain: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustFileArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustFileArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecListenerTlsValidationTrustFileArgs.builder()
            .certificateChain(certificateChain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecListenerTlsValidationTrustFileArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecListenerTlsValidationTrustFileArgsBuilder internal constructor() {
    private var certificateChain: Output<String>? = null

    /**
     * @param value Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("bdsokbtudqruqoul")
    public suspend fun certificateChain(`value`: Output<String>) {
        this.certificateChain = value
    }

    /**
     * @param value Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("crajjrimnkwgougv")
    public suspend fun certificateChain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateChain = mapped
    }

    internal fun build(): VirtualGatewaySpecListenerTlsValidationTrustFileArgs =
        VirtualGatewaySpecListenerTlsValidationTrustFileArgs(
            certificateChain = certificateChain ?: throw PulumiNullFieldException("certificateChain"),
        )
}
