@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property jsons The logging format for JSON.
 * @property text The logging format for text. Must be between 1 and 1000 characters in length.
 */
public data class VirtualGatewaySpecLoggingAccessLogFileFormatArgs(
    public val jsons: Output<List<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>>? = null,
    public val text: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileFormatArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileFormatArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileFormatArgs.builder()
            .jsons(jsons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .text(text?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualGatewaySpecLoggingAccessLogFileFormatArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecLoggingAccessLogFileFormatArgsBuilder internal constructor() {
    private var jsons: Output<List<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>>? = null

    private var text: Output<String>? = null

    /**
     * @param value The logging format for JSON.
     */
    @JvmName("xhvnqtxpfhfrpqpg")
    public suspend fun jsons(`value`: Output<List<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>>) {
        this.jsons = value
    }

    @JvmName("niaxyyrpvirmjhjn")
    public suspend fun jsons(vararg values: Output<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>) {
        this.jsons = Output.all(values.asList())
    }

    /**
     * @param values The logging format for JSON.
     */
    @JvmName("uuqjupuyjjghhmfb")
    public suspend fun jsons(values: List<Output<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>>) {
        this.jsons = Output.all(values)
    }

    /**
     * @param value The logging format for text. Must be between 1 and 1000 characters in length.
     */
    @JvmName("ujpuxmoimgiccwrl")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value The logging format for JSON.
     */
    @JvmName("mrlqyunnogkvpgyu")
    public suspend fun jsons(`value`: List<VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("wdrolhlnwammyhsp")
    public suspend fun jsons(argument: List<suspend VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("uckwxdlcnbxnfotu")
    public suspend fun jsons(vararg argument: suspend VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("orfgmktbgvxghnof")
    public suspend fun jsons(argument: suspend VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param values The logging format for JSON.
     */
    @JvmName("gehfhsmdenrsivou")
    public suspend fun jsons(vararg values: VirtualGatewaySpecLoggingAccessLogFileFormatJsonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsons = mapped
    }

    /**
     * @param value The logging format for text. Must be between 1 and 1000 characters in length.
     */
    @JvmName("lfonwwvodratgncx")
    public suspend fun text(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.text = mapped
    }

    internal fun build(): VirtualGatewaySpecLoggingAccessLogFileFormatArgs =
        VirtualGatewaySpecLoggingAccessLogFileFormatArgs(
            jsons = jsons,
            text = text,
        )
}
