@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessLog Access log configuration for a virtual gateway.
 */
public data class VirtualGatewaySpecLoggingArgs(
    public val accessLog: Output<VirtualGatewaySpecLoggingAccessLogArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs =
        com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs.builder()
            .accessLog(accessLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualGatewaySpecLoggingArgs].
 */
@PulumiTagMarker
public class VirtualGatewaySpecLoggingArgsBuilder internal constructor() {
    private var accessLog: Output<VirtualGatewaySpecLoggingAccessLogArgs>? = null

    /**
     * @param value Access log configuration for a virtual gateway.
     */
    @JvmName("issdvhxqxsrlecig")
    public suspend fun accessLog(`value`: Output<VirtualGatewaySpecLoggingAccessLogArgs>) {
        this.accessLog = value
    }

    /**
     * @param value Access log configuration for a virtual gateway.
     */
    @JvmName("ikvhrojfvdqyjpjv")
    public suspend fun accessLog(`value`: VirtualGatewaySpecLoggingAccessLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLog = mapped
    }

    /**
     * @param argument Access log configuration for a virtual gateway.
     */
    @JvmName("hordhguylhotmlga")
    public suspend fun accessLog(argument: suspend VirtualGatewaySpecLoggingAccessLogArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecLoggingAccessLogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accessLog = mapped
    }

    internal fun build(): VirtualGatewaySpecLoggingArgs = VirtualGatewaySpecLoggingArgs(
        accessLog = accessLog,
    )
}
