@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backendDefaults Defaults for backends.
 * @property backends Backends to which the virtual node is expected to send outbound traffic.
 * @property listeners Listeners from which the virtual node is expected to receive inbound traffic.
 * @property logging Inbound and outbound access logging information for the virtual node.
 * @property serviceDiscovery Service discovery information for the virtual node.
 */
public data class VirtualNodeSpecArgs(
    public val backendDefaults: Output<VirtualNodeSpecBackendDefaultsArgs>? = null,
    public val backends: Output<List<VirtualNodeSpecBackendArgs>>? = null,
    public val listeners: Output<List<VirtualNodeSpecListenerArgs>>? = null,
    public val logging: Output<VirtualNodeSpecLoggingArgs>? = null,
    public val serviceDiscovery: Output<VirtualNodeSpecServiceDiscoveryArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs.builder()
            .backendDefaults(backendDefaults?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backends(
                backends?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceDiscovery(
                serviceDiscovery?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNodeSpecArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecArgsBuilder internal constructor() {
    private var backendDefaults: Output<VirtualNodeSpecBackendDefaultsArgs>? = null

    private var backends: Output<List<VirtualNodeSpecBackendArgs>>? = null

    private var listeners: Output<List<VirtualNodeSpecListenerArgs>>? = null

    private var logging: Output<VirtualNodeSpecLoggingArgs>? = null

    private var serviceDiscovery: Output<VirtualNodeSpecServiceDiscoveryArgs>? = null

    /**
     * @param value Defaults for backends.
     */
    @JvmName("vhhakstvbmvjjeiq")
    public suspend fun backendDefaults(`value`: Output<VirtualNodeSpecBackendDefaultsArgs>) {
        this.backendDefaults = value
    }

    /**
     * @param value Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("vheisbqohfnhmadl")
    public suspend fun backends(`value`: Output<List<VirtualNodeSpecBackendArgs>>) {
        this.backends = value
    }

    @JvmName("udtrwlwabgeafwpb")
    public suspend fun backends(vararg values: Output<VirtualNodeSpecBackendArgs>) {
        this.backends = Output.all(values.asList())
    }

    /**
     * @param values Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("ecihgcbsxfsthhqr")
    public suspend fun backends(values: List<Output<VirtualNodeSpecBackendArgs>>) {
        this.backends = Output.all(values)
    }

    /**
     * @param value Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("hxpoxyjjysgetlwm")
    public suspend fun listeners(`value`: Output<List<VirtualNodeSpecListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("ovdrknnjmtcsfqwq")
    public suspend fun listeners(vararg values: Output<VirtualNodeSpecListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("tinfryyxfxmmyskg")
    public suspend fun listeners(values: List<Output<VirtualNodeSpecListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value Inbound and outbound access logging information for the virtual node.
     */
    @JvmName("nhqjmrpwjpduuvxb")
    public suspend fun logging(`value`: Output<VirtualNodeSpecLoggingArgs>) {
        this.logging = value
    }

    /**
     * @param value Service discovery information for the virtual node.
     */
    @JvmName("eijvukewqqfknljj")
    public suspend fun serviceDiscovery(`value`: Output<VirtualNodeSpecServiceDiscoveryArgs>) {
        this.serviceDiscovery = value
    }

    /**
     * @param value Defaults for backends.
     */
    @JvmName("inthbyvwxuihnjcm")
    public suspend fun backendDefaults(`value`: VirtualNodeSpecBackendDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendDefaults = mapped
    }

    /**
     * @param argument Defaults for backends.
     */
    @JvmName("seflnymuxdbdqgje")
    public suspend fun backendDefaults(argument: suspend VirtualNodeSpecBackendDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendDefaultsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendDefaults = mapped
    }

    /**
     * @param value Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("kjddhiqefewkokgc")
    public suspend fun backends(`value`: List<VirtualNodeSpecBackendArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param argument Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("hwsxknsiuxaduhlh")
    public suspend fun backends(argument: List<suspend VirtualNodeSpecBackendArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecBackendArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param argument Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("kamsbliqrwnvocnt")
    public suspend fun backends(vararg argument: suspend VirtualNodeSpecBackendArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecBackendArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param argument Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("jyhqtgfffwmykcyl")
    public suspend fun backends(argument: suspend VirtualNodeSpecBackendArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNodeSpecBackendArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backends = mapped
    }

    /**
     * @param values Backends to which the virtual node is expected to send outbound traffic.
     */
    @JvmName("igydqlsactptbsth")
    public suspend fun backends(vararg values: VirtualNodeSpecBackendArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param value Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("apftbutesbnycsvq")
    public suspend fun listeners(`value`: List<VirtualNodeSpecListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("lusudnluhaxdxeuf")
    public suspend fun listeners(argument: List<suspend VirtualNodeSpecListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("xioetfieyfuhogsn")
    public suspend fun listeners(vararg argument: suspend VirtualNodeSpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("nnkbosiousaljdki")
    public suspend fun listeners(argument: suspend VirtualNodeSpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values Listeners from which the virtual node is expected to receive inbound traffic.
     */
    @JvmName("ykuhrlgnpkcpxucy")
    public suspend fun listeners(vararg values: VirtualNodeSpecListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param value Inbound and outbound access logging information for the virtual node.
     */
    @JvmName("rknqgffufaqnmcfi")
    public suspend fun logging(`value`: VirtualNodeSpecLoggingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument Inbound and outbound access logging information for the virtual node.
     */
    @JvmName("eqtkldksydegjnxy")
    public suspend fun logging(argument: suspend VirtualNodeSpecLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecLoggingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    /**
     * @param value Service discovery information for the virtual node.
     */
    @JvmName("jgmbwpdumrpkokuf")
    public suspend fun serviceDiscovery(`value`: VirtualNodeSpecServiceDiscoveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDiscovery = mapped
    }

    /**
     * @param argument Service discovery information for the virtual node.
     */
    @JvmName("nsrefjqfgihjctqm")
    public suspend fun serviceDiscovery(argument: suspend VirtualNodeSpecServiceDiscoveryArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecServiceDiscoveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceDiscovery = mapped
    }

    internal fun build(): VirtualNodeSpecArgs = VirtualNodeSpecArgs(
        backendDefaults = backendDefaults,
        backends = backends,
        listeners = listeners,
        logging = logging,
        serviceDiscovery = serviceDiscovery,
    )
}
