@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property virtualService Virtual service to use as a backend for a virtual node.
 */
public data class VirtualNodeSpecBackendArgs(
    public val virtualService: Output<VirtualNodeSpecBackendVirtualServiceArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendArgs.builder()
            .virtualService(
                virtualService.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNodeSpecBackendArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendArgsBuilder internal constructor() {
    private var virtualService: Output<VirtualNodeSpecBackendVirtualServiceArgs>? = null

    /**
     * @param value Virtual service to use as a backend for a virtual node.
     */
    @JvmName("xvoystmcmajhxdus")
    public suspend fun virtualService(`value`: Output<VirtualNodeSpecBackendVirtualServiceArgs>) {
        this.virtualService = value
    }

    /**
     * @param value Virtual service to use as a backend for a virtual node.
     */
    @JvmName("frawxrbfkrpgsrif")
    public suspend fun virtualService(`value`: VirtualNodeSpecBackendVirtualServiceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualService = mapped
    }

    /**
     * @param argument Virtual service to use as a backend for a virtual node.
     */
    @JvmName("mfjroeuqitdlqxkd")
    public suspend fun virtualService(argument: suspend VirtualNodeSpecBackendVirtualServiceArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecBackendVirtualServiceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualService = mapped
    }

    internal fun build(): VirtualNodeSpecBackendArgs = VirtualNodeSpecBackendArgs(
        virtualService = virtualService ?: throw PulumiNullFieldException("virtualService"),
    )
}
