@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file Local file certificate.
 * @property sds A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs(
    public val `file`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgs>? =
        null,
    public val sds: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs.builder()
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgsBuilder internal constructor() {
    private var `file`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgs>? =
        null

    private var sds: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>? = null

    /**
     * @param value Local file certificate.
     */
    @JvmName("qhnbuticwombkxbo")
    public suspend fun `file`(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ipthakxpyytiafhi")
    public suspend fun sds(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value Local file certificate.
     */
    @JvmName("uvkcueclprhkrhjx")
    public suspend fun `file`(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument Local file certificate.
     */
    @JvmName("xsbvbfexgnmqhqwp")
    public suspend fun `file`(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("rhqjrwfenkinfyqh")
    public suspend fun sds(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument A [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ypptggqcdwpmpsfg")
    public suspend fun sds(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs =
        VirtualNodeSpecBackendDefaultsClientPolicyTlsCertificateArgs(
            `file` = `file`,
            sds = sds,
        )
}
