@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property subjectAlternativeNames SANs for a TLS validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs(
    public val subjectAlternativeNames: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null,
    public val trust: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs.builder()
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .trust(trust.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgsBuilder internal constructor() {
    private var subjectAlternativeNames:
        Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>? =
        null

    private var trust: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs>? =
        null

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("lyxfkrtfyyxvmfxi")
    public suspend fun subjectAlternativeNames(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs>) {
        this.subjectAlternativeNames = value
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("kimdivdegjxtgxuh")
    public suspend fun trust(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs>) {
        this.trust = value
    }

    /**
     * @param value SANs for a TLS validation context.
     */
    @JvmName("tipxcutofngobatm")
    public suspend fun subjectAlternativeNames(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param argument SANs for a TLS validation context.
     */
    @JvmName("vgdpdvrmfkeammea")
    public suspend fun subjectAlternativeNames(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNamesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value TLS validation context trust.
     */
    @JvmName("xrvojwtjiudsgrkg")
    public suspend fun trust(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trust = mapped
    }

    /**
     * @param argument TLS validation context trust.
     */
    @JvmName("jigvxbacnoodiwew")
    public suspend fun trust(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trust = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs =
        VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationArgs(
            subjectAlternativeNames = subjectAlternativeNames,
            trust = trust ?: throw PulumiNullFieldException("trust"),
        )
}
