@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acm TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs(
    public val acm: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>? =
        null,
    public val `file`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>? =
        null,
    public val sds: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs.builder()
            .acm(acm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgsBuilder internal constructor() {
    private var acm: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>? =
        null

    private var `file`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>? =
        null

    private var sds: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>? =
        null

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("cnpxorxfktjnkclf")
    public suspend fun acm(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs>) {
        this.acm = value
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("xrflcmkhojwrbmqm")
    public suspend fun `file`(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("gntsktvirgfsbjcr")
    public suspend fun sds(`value`: Output<VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("ovhrpjhqtfhekmet")
    public suspend fun acm(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acm = mapped
    }

    /**
     * @param argument TLS validation context trust for an AWS Certificate Manager (ACM) certificate.
     */
    @JvmName("ohlmwhttkwnwlbpk")
    public suspend fun acm(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustAcmArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acm = mapped
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("hvhdcdrbubjuggyf")
    public suspend fun `file`(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument TLS validation context trust for a local file certificate.
     */
    @JvmName("nspjlvxsklrwsiak")
    public suspend fun `file`(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustFileArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("fuijbasqtgrunveo")
    public suspend fun sds(`value`: VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("awvvtuaiujgdbihc")
    public suspend fun sds(argument: suspend VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustSdsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs =
        VirtualNodeSpecBackendDefaultsClientPolicyTlsValidationTrustArgs(
            acm = acm,
            `file` = `file`,
            sds = sds,
        )
}
