@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property enforce Whether the policy is enforced. Default is `true`.
 * @property ports One or more ports that the policy is enforced for.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs(
    public val certificate: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs>? = null,
    public val enforce: Output<Boolean>? = null,
    public val ports: Output<List<Int>>? = null,
    public val validation: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enforce(enforce?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .validation(validation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgsBuilder internal constructor() {
    private var certificate:
        Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs>? = null

    private var enforce: Output<Boolean>? = null

    private var ports: Output<List<Int>>? = null

    private var validation: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs>? =
        null

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("jdsivdjlojmnikrf")
    public suspend fun certificate(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs>) {
        this.certificate = value
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("aacuivdmjcklkkji")
    public suspend fun enforce(`value`: Output<Boolean>) {
        this.enforce = value
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("cyuyyornecfucpdy")
    public suspend fun ports(`value`: Output<List<Int>>) {
        this.ports = value
    }

    @JvmName("lbgyrebwtyxipqqh")
    public suspend fun ports(vararg values: Output<Int>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("tpmvhtulbwftaclu")
    public suspend fun ports(values: List<Output<Int>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("hidekysimpoufduw")
    public suspend fun validation(`value`: Output<VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value Listener's TLS certificate.
     */
    @JvmName("pxdfsyjfvhkjmtle")
    public suspend fun certificate(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Listener's TLS certificate.
     */
    @JvmName("lmguqxhorhvdbuln")
    public suspend fun certificate(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsCertificateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Whether the policy is enforced. Default is `true`.
     */
    @JvmName("ubmvwwrlmyqrfynb")
    public suspend fun enforce(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value One or more ports that the policy is enforced for.
     */
    @JvmName("fciuuhdiwqyfsaem")
    public suspend fun ports(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values One or more ports that the policy is enforced for.
     */
    @JvmName("mevepaicalehutkt")
    public suspend fun ports(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("ukmmsjwyitxpnpop")
    public suspend fun validation(`value`: VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument Listener's Transport Layer Security (TLS) validation context.
     */
    @JvmName("eimncyltdehlggjm")
    public suspend fun validation(argument: suspend VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsArgs(
            certificate = certificate,
            enforce = enforce,
            ports = ports,
            validation = validation ?: throw PulumiNullFieldException("validation"),
        )
}
