@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificateAuthorityArns One or more ACM ARNs.
 */
public data class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs(
    public val certificateAuthorityArns: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs.builder()
            .certificateAuthorityArns(
                certificateAuthorityArns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgsBuilder
internal constructor() {
    private var certificateAuthorityArns: Output<List<String>>? = null

    /**
     * @param value One or more ACM ARNs.
     */
    @JvmName("afmqxxrlasoymmpe")
    public suspend fun certificateAuthorityArns(`value`: Output<List<String>>) {
        this.certificateAuthorityArns = value
    }

    @JvmName("tesnfaabiaspstsn")
    public suspend fun certificateAuthorityArns(vararg values: Output<String>) {
        this.certificateAuthorityArns = Output.all(values.asList())
    }

    /**
     * @param values One or more ACM ARNs.
     */
    @JvmName("mugvmnkwjofhhkil")
    public suspend fun certificateAuthorityArns(values: List<Output<String>>) {
        this.certificateAuthorityArns = Output.all(values)
    }

    /**
     * @param value One or more ACM ARNs.
     */
    @JvmName("uaxvrgvjntwucwlp")
    public suspend fun certificateAuthorityArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    /**
     * @param values One or more ACM ARNs.
     */
    @JvmName("fhdabubpbntivobc")
    public suspend fun certificateAuthorityArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateAuthorityArns = mapped
    }

    internal fun build(): VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs =
        VirtualNodeSpecBackendVirtualServiceClientPolicyTlsValidationTrustAcmArgs(
            certificateAuthorityArns = certificateAuthorityArns ?: throw
                PulumiNullFieldException("certificateAuthorityArns"),
        )
}
