@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property grpc Connection pool information for gRPC listeners.
 * @property http2s Connection pool information for HTTP2 listeners.
 * @property https Connection pool information for HTTP listeners.
 * @property tcps Connection pool information for TCP listeners.
 */
public data class VirtualNodeSpecListenerConnectionPoolArgs(
    public val grpc: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>? = null,
    public val http2s: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>? = null,
    public val https: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>? = null,
    public val tcps: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolArgs.builder()
            .grpc(grpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2s(http2s?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .https(https?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tcps(
                tcps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNodeSpecListenerConnectionPoolArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerConnectionPoolArgsBuilder internal constructor() {
    private var grpc: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>? = null

    private var http2s: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>? = null

    private var https: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>? = null

    private var tcps: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>? = null

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("nqswwaqsuupwutco")
    public suspend fun grpc(`value`: Output<VirtualNodeSpecListenerConnectionPoolGrpcArgs>) {
        this.grpc = value
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("ryfrrlqkndiivabf")
    public suspend fun http2s(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolHttp2Args>>) {
        this.http2s = value
    }

    @JvmName("niyusvgfgnvjjtec")
    public suspend fun http2s(vararg values: Output<VirtualNodeSpecListenerConnectionPoolHttp2Args>) {
        this.http2s = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for HTTP2 listeners.
     */
    @JvmName("pchewgneoorwklko")
    public suspend fun http2s(values: List<Output<VirtualNodeSpecListenerConnectionPoolHttp2Args>>) {
        this.http2s = Output.all(values)
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("nscxatlwmgabitxg")
    public suspend fun https(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolHttpArgs>>) {
        this.https = value
    }

    @JvmName("cqhvgttkxumscvqi")
    public suspend fun https(vararg values: Output<VirtualNodeSpecListenerConnectionPoolHttpArgs>) {
        this.https = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for HTTP listeners.
     */
    @JvmName("rhobroynkvgeagcp")
    public suspend fun https(values: List<Output<VirtualNodeSpecListenerConnectionPoolHttpArgs>>) {
        this.https = Output.all(values)
    }

    /**
     * @param value Connection pool information for TCP listeners.
     */
    @JvmName("dwfllmajqwhidflp")
    public suspend fun tcps(`value`: Output<List<VirtualNodeSpecListenerConnectionPoolTcpArgs>>) {
        this.tcps = value
    }

    @JvmName("tsudqcjvwpxvlwut")
    public suspend fun tcps(vararg values: Output<VirtualNodeSpecListenerConnectionPoolTcpArgs>) {
        this.tcps = Output.all(values.asList())
    }

    /**
     * @param values Connection pool information for TCP listeners.
     */
    @JvmName("dbsjwntbqpsrnyne")
    public suspend fun tcps(values: List<Output<VirtualNodeSpecListenerConnectionPoolTcpArgs>>) {
        this.tcps = Output.all(values)
    }

    /**
     * @param value Connection pool information for gRPC listeners.
     */
    @JvmName("eoqymnhyewcatual")
    public suspend fun grpc(`value`: VirtualNodeSpecListenerConnectionPoolGrpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpc = mapped
    }

    /**
     * @param argument Connection pool information for gRPC listeners.
     */
    @JvmName("rwslvedcxnpdlvtq")
    public suspend fun grpc(argument: suspend VirtualNodeSpecListenerConnectionPoolGrpcArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerConnectionPoolGrpcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grpc = mapped
    }

    /**
     * @param value Connection pool information for HTTP2 listeners.
     */
    @JvmName("ivjwqfkvrwoeicci")
    public suspend fun http2s(`value`: List<VirtualNodeSpecListenerConnectionPoolHttp2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("bjtvklqqnniphrdb")
    public suspend fun http2s(argument: List<suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("nmxehocyukwwaivk")
    public suspend fun http2s(vararg argument: suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param argument Connection pool information for HTTP2 listeners.
     */
    @JvmName("rvfhljvertpiesry")
    public suspend fun http2s(argument: suspend VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolHttp2ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.http2s = mapped
    }

    /**
     * @param values Connection pool information for HTTP2 listeners.
     */
    @JvmName("sgxwcwynogywixir")
    public suspend fun http2s(vararg values: VirtualNodeSpecListenerConnectionPoolHttp2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.http2s = mapped
    }

    /**
     * @param value Connection pool information for HTTP listeners.
     */
    @JvmName("pqvvdlxshfmxvgus")
    public suspend fun https(`value`: List<VirtualNodeSpecListenerConnectionPoolHttpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("wtqsmcvqekqsmqkj")
    public suspend fun https(argument: List<suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("xmvuusyximhgjtdk")
    public suspend fun https(vararg argument: suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param argument Connection pool information for HTTP listeners.
     */
    @JvmName("eyphuwestgijonvq")
    public suspend fun https(argument: suspend VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolHttpArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.https = mapped
    }

    /**
     * @param values Connection pool information for HTTP listeners.
     */
    @JvmName("hbqwifstrwvaurwu")
    public suspend fun https(vararg values: VirtualNodeSpecListenerConnectionPoolHttpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.https = mapped
    }

    /**
     * @param value Connection pool information for TCP listeners.
     */
    @JvmName("hujeqyjuflevmxtw")
    public suspend fun tcps(`value`: List<VirtualNodeSpecListenerConnectionPoolTcpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("kykbdctbluubtakc")
    public suspend fun tcps(argument: List<suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("ogcbndcrosgpvvjg")
    public suspend fun tcps(vararg argument: suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param argument Connection pool information for TCP listeners.
     */
    @JvmName("dbuyvalitkxtlajm")
    public suspend fun tcps(argument: suspend VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tcps = mapped
    }

    /**
     * @param values Connection pool information for TCP listeners.
     */
    @JvmName("lexssmkvhvfebvto")
    public suspend fun tcps(vararg values: VirtualNodeSpecListenerConnectionPoolTcpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcps = mapped
    }

    internal fun build(): VirtualNodeSpecListenerConnectionPoolArgs =
        VirtualNodeSpecListenerConnectionPoolArgs(
            grpc = grpc,
            http2s = http2s,
            https = https,
            tcps = tcps,
        )
}
