@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolGrpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRequests Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
 */
public data class VirtualNodeSpecListenerConnectionPoolGrpcArgs(
    public val maxRequests: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolGrpcArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolGrpcArgs = com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolGrpcArgs.builder()
        .maxRequests(maxRequests.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerConnectionPoolGrpcArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerConnectionPoolGrpcArgsBuilder internal constructor() {
    private var maxRequests: Output<Int>? = null

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("pssmvkkfciguajqf")
    public suspend fun maxRequests(`value`: Output<Int>) {
        this.maxRequests = value
    }

    /**
     * @param value Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("kmwggydqfmpbwpfw")
    public suspend fun maxRequests(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRequests = mapped
    }

    internal fun build(): VirtualNodeSpecListenerConnectionPoolGrpcArgs =
        VirtualNodeSpecListenerConnectionPoolGrpcArgs(
            maxRequests = maxRequests ?: throw PulumiNullFieldException("maxRequests"),
        )
}
