@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolTcpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxConnections Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
 */
public data class VirtualNodeSpecListenerConnectionPoolTcpArgs(
    public val maxConnections: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolTcpArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolTcpArgs = com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerConnectionPoolTcpArgs.builder()
        .maxConnections(maxConnections.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerConnectionPoolTcpArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerConnectionPoolTcpArgsBuilder internal constructor() {
    private var maxConnections: Output<Int>? = null

    /**
     * @param value Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("rklivditcaeagbdj")
    public suspend fun maxConnections(`value`: Output<Int>) {
        this.maxConnections = value
    }

    /**
     * @param value Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster. Minimum value of `1`.
     */
    @JvmName("ipeutmqtpiivnhlb")
    public suspend fun maxConnections(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxConnections = mapped
    }

    internal fun build(): VirtualNodeSpecListenerConnectionPoolTcpArgs =
        VirtualNodeSpecListenerConnectionPoolTcpArgs(
            maxConnections = maxConnections ?: throw PulumiNullFieldException("maxConnections"),
        )
}
