@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property healthyThreshold Number of consecutive successful health checks that must occur before declaring listener healthy.
 * @property intervalMillis Time period in milliseconds between each health check execution.
 * @property path Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
 * @property port Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
 * @property protocol Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
 * @property timeoutMillis Amount of time to wait when receiving a response from the health check, in milliseconds.
 * @property unhealthyThreshold Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
 */
public data class VirtualNodeSpecListenerHealthCheckArgs(
    public val healthyThreshold: Output<Int>,
    public val intervalMillis: Output<Int>,
    public val path: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>,
    public val timeoutMillis: Output<Int>,
    public val unhealthyThreshold: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerHealthCheckArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerHealthCheckArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerHealthCheckArgs.builder()
            .healthyThreshold(healthyThreshold.applyValue({ args0 -> args0 }))
            .intervalMillis(intervalMillis.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .timeoutMillis(timeoutMillis.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerHealthCheckArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerHealthCheckArgsBuilder internal constructor() {
    private var healthyThreshold: Output<Int>? = null

    private var intervalMillis: Output<Int>? = null

    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var timeoutMillis: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value Number of consecutive successful health checks that must occur before declaring listener healthy.
     */
    @JvmName("ygbhdfqywspepnxm")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value Time period in milliseconds between each health check execution.
     */
    @JvmName("lnfsetmknsxruuub")
    public suspend fun intervalMillis(`value`: Output<Int>) {
        this.intervalMillis = value
    }

    /**
     * @param value Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
     */
    @JvmName("gltjgjadjklmtfqn")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
     */
    @JvmName("nkvswbsxglovwijk")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("wpbhfrkdirbcgnhw")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Amount of time to wait when receiving a response from the health check, in milliseconds.
     */
    @JvmName("jaooyuvjhekluepd")
    public suspend fun timeoutMillis(`value`: Output<Int>) {
        this.timeoutMillis = value
    }

    /**
     * @param value Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     */
    @JvmName("snkbpkjxbxeblyed")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Number of consecutive successful health checks that must occur before declaring listener healthy.
     */
    @JvmName("hsygxsuxhcxbyiye")
    public suspend fun healthyThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value Time period in milliseconds between each health check execution.
     */
    @JvmName("ypbbadgkcaqgssvk")
    public suspend fun intervalMillis(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intervalMillis = mapped
    }

    /**
     * @param value Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
     */
    @JvmName("pmfunjcjsvmtottx")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
     */
    @JvmName("cintovnvbordmmak")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
     */
    @JvmName("dywwegfkdjyxmyeb")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Amount of time to wait when receiving a response from the health check, in milliseconds.
     */
    @JvmName("mgdyoyuihxeiqybk")
    public suspend fun timeoutMillis(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeoutMillis = mapped
    }

    /**
     * @param value Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     */
    @JvmName("yjlfhxyrclcmonci")
    public suspend fun unhealthyThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): VirtualNodeSpecListenerHealthCheckArgs =
        VirtualNodeSpecListenerHealthCheckArgs(
            healthyThreshold = healthyThreshold ?: throw PulumiNullFieldException("healthyThreshold"),
            intervalMillis = intervalMillis ?: throw PulumiNullFieldException("intervalMillis"),
            path = path,
            port = port,
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            timeoutMillis = timeoutMillis ?: throw PulumiNullFieldException("timeoutMillis"),
            unhealthyThreshold = unhealthyThreshold ?: throw PulumiNullFieldException("unhealthyThreshold"),
        )
}
