@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutGrpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class VirtualNodeSpecListenerTimeoutGrpcArgs(
    public val idle: Output<VirtualNodeSpecListenerTimeoutGrpcIdleArgs>? = null,
    public val perRequest: Output<VirtualNodeSpecListenerTimeoutGrpcPerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutGrpcArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutGrpcArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutGrpcArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTimeoutGrpcArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTimeoutGrpcArgsBuilder internal constructor() {
    private var idle: Output<VirtualNodeSpecListenerTimeoutGrpcIdleArgs>? = null

    private var perRequest: Output<VirtualNodeSpecListenerTimeoutGrpcPerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("slkibylgbrvlqetp")
    public suspend fun idle(`value`: Output<VirtualNodeSpecListenerTimeoutGrpcIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("dmrhkjoowqvdtplv")
    public suspend fun perRequest(`value`: Output<VirtualNodeSpecListenerTimeoutGrpcPerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("fgvkrsxxqpnctcmm")
    public suspend fun idle(`value`: VirtualNodeSpecListenerTimeoutGrpcIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("gvwvyqcyeokgutuy")
    public suspend fun idle(argument: suspend VirtualNodeSpecListenerTimeoutGrpcIdleArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutGrpcIdleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("hkpvgbcbsfwidwve")
    public suspend fun perRequest(`value`: VirtualNodeSpecListenerTimeoutGrpcPerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("yoljqqvnwbkejlkk")
    public suspend fun perRequest(argument: suspend VirtualNodeSpecListenerTimeoutGrpcPerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutGrpcPerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTimeoutGrpcArgs =
        VirtualNodeSpecListenerTimeoutGrpcArgs(
            idle = idle,
            perRequest = perRequest,
        )
}
