@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttp2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class VirtualNodeSpecListenerTimeoutHttp2Args(
    public val idle: Output<VirtualNodeSpecListenerTimeoutHttp2IdleArgs>? = null,
    public val perRequest: Output<VirtualNodeSpecListenerTimeoutHttp2PerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttp2Args> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttp2Args =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTimeoutHttp2Args.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTimeoutHttp2Args].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTimeoutHttp2ArgsBuilder internal constructor() {
    private var idle: Output<VirtualNodeSpecListenerTimeoutHttp2IdleArgs>? = null

    private var perRequest: Output<VirtualNodeSpecListenerTimeoutHttp2PerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("ampspdnavfdmqtwp")
    public suspend fun idle(`value`: Output<VirtualNodeSpecListenerTimeoutHttp2IdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("pbuvpelemgcgugfu")
    public suspend fun perRequest(`value`: Output<VirtualNodeSpecListenerTimeoutHttp2PerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("hunqfwqnkpcsruii")
    public suspend fun idle(`value`: VirtualNodeSpecListenerTimeoutHttp2IdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("asamydaggpbctuvd")
    public suspend fun idle(argument: suspend VirtualNodeSpecListenerTimeoutHttp2IdleArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttp2IdleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("nneaexqhqfxebxba")
    public suspend fun perRequest(`value`: VirtualNodeSpecListenerTimeoutHttp2PerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("xlkjulelerfgftpv")
    public suspend fun perRequest(argument: suspend VirtualNodeSpecListenerTimeoutHttp2PerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTimeoutHttp2PerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTimeoutHttp2Args =
        VirtualNodeSpecListenerTimeoutHttp2Args(
            idle = idle,
            perRequest = perRequest,
        )
}
