@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateChain Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
 * @property privateKey Private key for a certificate stored on the file system of the virtual node that the proxy is running on. Must be between 1 and 255 characters in length.
 */
public data class VirtualNodeSpecListenerTlsCertificateFileArgs(
    public val certificateChain: Output<String>,
    public val privateKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateFileArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateFileArgs = com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsCertificateFileArgs.builder()
        .certificateChain(certificateChain.applyValue({ args0 -> args0 }))
        .privateKey(privateKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsCertificateFileArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsCertificateFileArgsBuilder internal constructor() {
    private var certificateChain: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("rocuphfqxytsloga")
    public suspend fun certificateChain(`value`: Output<String>) {
        this.certificateChain = value
    }

    /**
     * @param value Private key for a certificate stored on the file system of the virtual node that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("cfbjjwfukxxithiu")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Certificate trust chain for a certificate stored on the file system of the mesh endpoint that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("hddwkddkyxorklgt")
    public suspend fun certificateChain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateChain = mapped
    }

    /**
     * @param value Private key for a certificate stored on the file system of the virtual node that the proxy is running on. Must be between 1 and 255 characters in length.
     */
    @JvmName("pqdhjmojetrvhiwx")
    public suspend fun privateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsCertificateFileArgs =
        VirtualNodeSpecListenerTlsCertificateFileArgs(
            certificateChain = certificateChain ?: throw PulumiNullFieldException("certificateChain"),
            privateKey = privateKey ?: throw PulumiNullFieldException("privateKey"),
        )
}
