@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match Criteria for determining a SAN's match.
 */
public data class VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs(
    public val match: Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs.builder()
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgsBuilder internal constructor() {
    private var match: Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>? =
        null

    /**
     * @param value Criteria for determining a SAN's match.
     */
    @JvmName("faslnkjrdoakjses")
    public suspend fun match(`value`: Output<VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Criteria for determining a SAN's match.
     */
    @JvmName("urthajolypevrobj")
    public suspend fun match(`value`: VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining a SAN's match.
     */
    @JvmName("gomaylvfdqpomhrm")
    public suspend fun match(argument: suspend VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs =
        VirtualNodeSpecListenerTlsValidationSubjectAlternativeNamesArgs(
            match = match ?: throw PulumiNullFieldException("match"),
        )
}
