@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property file TLS validation context trust for a local file certificate.
 * @property sds TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
 */
public data class VirtualNodeSpecListenerTlsValidationTrustArgs(
    public val `file`: Output<VirtualNodeSpecListenerTlsValidationTrustFileArgs>? = null,
    public val sds: Output<VirtualNodeSpecListenerTlsValidationTrustSdsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationTrustArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationTrustArgs = com.pulumi.aws.appmesh.inputs.VirtualNodeSpecListenerTlsValidationTrustArgs.builder()
        .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .sds(sds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualNodeSpecListenerTlsValidationTrustArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecListenerTlsValidationTrustArgsBuilder internal constructor() {
    private var `file`: Output<VirtualNodeSpecListenerTlsValidationTrustFileArgs>? = null

    private var sds: Output<VirtualNodeSpecListenerTlsValidationTrustSdsArgs>? = null

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("corcplabhoqrviep")
    public suspend fun `file`(`value`: Output<VirtualNodeSpecListenerTlsValidationTrustFileArgs>) {
        this.`file` = value
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("joswxljlrgewpgdn")
    public suspend fun sds(`value`: Output<VirtualNodeSpecListenerTlsValidationTrustSdsArgs>) {
        this.sds = value
    }

    /**
     * @param value TLS validation context trust for a local file certificate.
     */
    @JvmName("htrttglhxajdryxx")
    public suspend fun `file`(`value`: VirtualNodeSpecListenerTlsValidationTrustFileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument TLS validation context trust for a local file certificate.
     */
    @JvmName("crrplgbjqslieedr")
    public suspend fun `file`(argument: suspend VirtualNodeSpecListenerTlsValidationTrustFileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsValidationTrustFileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("ujxqcfjsdwwofpve")
    public suspend fun sds(`value`: VirtualNodeSpecListenerTlsValidationTrustSdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sds = mapped
    }

    /**
     * @param argument TLS validation context trust for a [Secret Discovery Service](https://www.envoyproxy.io/docs/envoy/latest/configuration/security/secret#secret-discovery-service-sds) certificate.
     */
    @JvmName("lrbyauxpdxughjcw")
    public suspend fun sds(argument: suspend VirtualNodeSpecListenerTlsValidationTrustSdsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecListenerTlsValidationTrustSdsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sds = mapped
    }

    internal fun build(): VirtualNodeSpecListenerTlsValidationTrustArgs =
        VirtualNodeSpecListenerTlsValidationTrustArgs(
            `file` = `file`,
            sds = sds,
        )
}
