@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property format The specified format for the logs.
 * @property path File path to write access logs to. You can use `/dev/stdout` to send access logs to standard out. Must be between 1 and 255 characters in length.
 */
public data class VirtualNodeSpecLoggingAccessLogFileArgs(
    public val format: Output<VirtualNodeSpecLoggingAccessLogFileFormatArgs>? = null,
    public val path: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileArgs.builder()
            .format(format?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecLoggingAccessLogFileArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecLoggingAccessLogFileArgsBuilder internal constructor() {
    private var format: Output<VirtualNodeSpecLoggingAccessLogFileFormatArgs>? = null

    private var path: Output<String>? = null

    /**
     * @param value The specified format for the logs.
     */
    @JvmName("mxlgylodvhytifah")
    public suspend fun format(`value`: Output<VirtualNodeSpecLoggingAccessLogFileFormatArgs>) {
        this.format = value
    }

    /**
     * @param value File path to write access logs to. You can use `/dev/stdout` to send access logs to standard out. Must be between 1 and 255 characters in length.
     */
    @JvmName("cyvuwiqrybocdvuk")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The specified format for the logs.
     */
    @JvmName("aploywwjqhnsjkvj")
    public suspend fun format(`value`: VirtualNodeSpecLoggingAccessLogFileFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param argument The specified format for the logs.
     */
    @JvmName("smsroqkkjlcqehxc")
    public suspend fun format(argument: suspend VirtualNodeSpecLoggingAccessLogFileFormatArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNodeSpecLoggingAccessLogFileFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.format = mapped
    }

    /**
     * @param value File path to write access logs to. You can use `/dev/stdout` to send access logs to standard out. Must be between 1 and 255 characters in length.
     */
    @JvmName("xvgobeysxgvtoyxi")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): VirtualNodeSpecLoggingAccessLogFileArgs =
        VirtualNodeSpecLoggingAccessLogFileArgs(
            format = format,
            path = path ?: throw PulumiNullFieldException("path"),
        )
}
