@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property jsons The logging format for JSON.
 * @property text The logging format for text. Must be between 1 and 1000 characters in length.
 */
public data class VirtualNodeSpecLoggingAccessLogFileFormatArgs(
    public val jsons: Output<List<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>>? = null,
    public val text: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatArgs = com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileFormatArgs.builder()
        .jsons(jsons?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .text(text?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecLoggingAccessLogFileFormatArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecLoggingAccessLogFileFormatArgsBuilder internal constructor() {
    private var jsons: Output<List<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>>? = null

    private var text: Output<String>? = null

    /**
     * @param value The logging format for JSON.
     */
    @JvmName("iqbywncjewfkygqm")
    public suspend fun jsons(`value`: Output<List<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>>) {
        this.jsons = value
    }

    @JvmName("nmsdskfyjpwjkvxq")
    public suspend fun jsons(vararg values: Output<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>) {
        this.jsons = Output.all(values.asList())
    }

    /**
     * @param values The logging format for JSON.
     */
    @JvmName("ciwuqvmqgfcviaoo")
    public suspend fun jsons(values: List<Output<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>>) {
        this.jsons = Output.all(values)
    }

    /**
     * @param value The logging format for text. Must be between 1 and 1000 characters in length.
     */
    @JvmName("wtbgywktmvpykfep")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value The logging format for JSON.
     */
    @JvmName("xwhhiuknsvuivkko")
    public suspend fun jsons(`value`: List<VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("fgeyrseqqsxjmhfi")
    public suspend fun jsons(argument: List<suspend VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("bjjbjyxwcwfyocwc")
    public suspend fun jsons(vararg argument: suspend VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param argument The logging format for JSON.
     */
    @JvmName("jtmmviocyydstqjt")
    public suspend fun jsons(argument: suspend VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNodeSpecLoggingAccessLogFileFormatJsonArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.jsons = mapped
    }

    /**
     * @param values The logging format for JSON.
     */
    @JvmName("xvdqnniccsdaeqic")
    public suspend fun jsons(vararg values: VirtualNodeSpecLoggingAccessLogFileFormatJsonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsons = mapped
    }

    /**
     * @param value The logging format for text. Must be between 1 and 1000 characters in length.
     */
    @JvmName("sabpudppinpuqiyu")
    public suspend fun text(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.text = mapped
    }

    internal fun build(): VirtualNodeSpecLoggingAccessLogFileFormatArgs =
        VirtualNodeSpecLoggingAccessLogFileFormatArgs(
            jsons = jsons,
            text = text,
        )
}
