@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property attributes String map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.
 * @property namespaceName Name of the AWS Cloud Map namespace to use.
 * Use the `aws.servicediscovery.HttpNamespace` resource to configure a Cloud Map namespace. Must be between 1 and 1024 characters in length.
 * @property serviceName Name of the AWS Cloud Map service to use. Use the `aws.servicediscovery.Service` resource to configure a Cloud Map service. Must be between 1 and 1024 characters in length.
 */
public data class VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val namespaceName: Output<String>,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs =
        com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .namespaceName(namespaceName.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs].
 */
@PulumiTagMarker
public class VirtualNodeSpecServiceDiscoveryAwsCloudMapArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var namespaceName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value String map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.
     */
    @JvmName("yfftinfdajstowbu")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value Name of the AWS Cloud Map namespace to use.
     * Use the `aws.servicediscovery.HttpNamespace` resource to configure a Cloud Map namespace. Must be between 1 and 1024 characters in length.
     */
    @JvmName("wesfghubbrjhuatu")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the AWS Cloud Map service to use. Use the `aws.servicediscovery.Service` resource to configure a Cloud Map service. Must be between 1 and 1024 characters in length.
     */
    @JvmName("swrmugpydgrdaukp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value String map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.
     */
    @JvmName("hystbjuxabahrxfi")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values String map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.
     */
    @JvmName("ciyhopwoandybhlq")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Name of the AWS Cloud Map namespace to use.
     * Use the `aws.servicediscovery.HttpNamespace` resource to configure a Cloud Map namespace. Must be between 1 and 1024 characters in length.
     */
    @JvmName("nhjrbweooxirifui")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the AWS Cloud Map service to use. Use the `aws.servicediscovery.Service` resource to configure a Cloud Map service. Must be between 1 and 1024 characters in length.
     */
    @JvmName("jhdgakdblxepgoch")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs =
        VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs(
            attributes = attributes,
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
