@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property listeners Listeners that the virtual router is expected to receive inbound traffic from.
 * Currently only one listener is supported per virtual router.
 */
public data class VirtualRouterSpecArgs(
    public val listeners: Output<List<VirtualRouterSpecListenerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs =
        com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs.builder()
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualRouterSpecArgs].
 */
@PulumiTagMarker
public class VirtualRouterSpecArgsBuilder internal constructor() {
    private var listeners: Output<List<VirtualRouterSpecListenerArgs>>? = null

    /**
     * @param value Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("gpoyfgvkiyvalvfx")
    public suspend fun listeners(`value`: Output<List<VirtualRouterSpecListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("ckmglimlfaeubitb")
    public suspend fun listeners(vararg values: Output<VirtualRouterSpecListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("hpqypoeafgjjxgpx")
    public suspend fun listeners(values: List<Output<VirtualRouterSpecListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("evgxbykvmcspacof")
    public suspend fun listeners(`value`: List<VirtualRouterSpecListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("tisqvgkrymoceejo")
    public suspend fun listeners(argument: List<suspend VirtualRouterSpecListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualRouterSpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("pissotoihtvccyto")
    public suspend fun listeners(vararg argument: suspend VirtualRouterSpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualRouterSpecListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("cggfrisdfjewlesk")
    public suspend fun listeners(argument: suspend VirtualRouterSpecListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualRouterSpecListenerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values Listeners that the virtual router is expected to receive inbound traffic from.
     * Currently only one listener is supported per virtual router.
     */
    @JvmName("hfswhnqoddutdrrs")
    public suspend fun listeners(vararg values: VirtualRouterSpecListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    internal fun build(): VirtualRouterSpecArgs = VirtualRouterSpecArgs(
        listeners = listeners,
    )
}
