@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property virtualNode Virtual node associated with a virtual service.
 * @property virtualRouter Virtual router associated with a virtual service.
 */
public data class VirtualServiceSpecProviderArgs(
    public val virtualNode: Output<VirtualServiceSpecProviderVirtualNodeArgs>? = null,
    public val virtualRouter: Output<VirtualServiceSpecProviderVirtualRouterArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs =
        com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs.builder()
            .virtualNode(virtualNode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualRouter(virtualRouter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualServiceSpecProviderArgs].
 */
@PulumiTagMarker
public class VirtualServiceSpecProviderArgsBuilder internal constructor() {
    private var virtualNode: Output<VirtualServiceSpecProviderVirtualNodeArgs>? = null

    private var virtualRouter: Output<VirtualServiceSpecProviderVirtualRouterArgs>? = null

    /**
     * @param value Virtual node associated with a virtual service.
     */
    @JvmName("cgcjcutmpacxcyka")
    public suspend fun virtualNode(`value`: Output<VirtualServiceSpecProviderVirtualNodeArgs>) {
        this.virtualNode = value
    }

    /**
     * @param value Virtual router associated with a virtual service.
     */
    @JvmName("aoyodivpbkunqjfe")
    public suspend fun virtualRouter(`value`: Output<VirtualServiceSpecProviderVirtualRouterArgs>) {
        this.virtualRouter = value
    }

    /**
     * @param value Virtual node associated with a virtual service.
     */
    @JvmName("ihsnduyogmryfmfv")
    public suspend fun virtualNode(`value`: VirtualServiceSpecProviderVirtualNodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNode = mapped
    }

    /**
     * @param argument Virtual node associated with a virtual service.
     */
    @JvmName("byjfjbeqjleechuh")
    public suspend fun virtualNode(argument: suspend VirtualServiceSpecProviderVirtualNodeArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualServiceSpecProviderVirtualNodeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualNode = mapped
    }

    /**
     * @param value Virtual router associated with a virtual service.
     */
    @JvmName("usdawjxxhrctrqqf")
    public suspend fun virtualRouter(`value`: VirtualServiceSpecProviderVirtualRouterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualRouter = mapped
    }

    /**
     * @param argument Virtual router associated with a virtual service.
     */
    @JvmName("jcotfuhuverlspbd")
    public suspend fun virtualRouter(argument: suspend VirtualServiceSpecProviderVirtualRouterArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualServiceSpecProviderVirtualRouterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualRouter = mapped
    }

    internal fun build(): VirtualServiceSpecProviderArgs = VirtualServiceSpecProviderArgs(
        virtualNode = virtualNode,
        virtualRouter = virtualRouter,
    )
}
