@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property rewrite Gateway route action to rewrite.
 * @property target Target that traffic is routed to when a request matches the gateway route.
 */
public data class GatewayRouteSpecHttp2RouteAction(
    public val rewrite: GatewayRouteSpecHttp2RouteActionRewrite? = null,
    public val target: GatewayRouteSpecHttp2RouteActionTarget,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttp2RouteAction): GatewayRouteSpecHttp2RouteAction = GatewayRouteSpecHttp2RouteAction(
            rewrite = javaType.rewrite().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteActionRewrite.Companion.toKotlin(args0)
                })
            }).orElse(null),
            target = javaType.target().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteActionTarget.Companion.toKotlin(args0)
            }),
        )
    }
}
