@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property exact Header value sent by the client must match the specified value exactly.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property range Object that specifies the range of numbers that the header value sent by the client must be included in.
 * @property regex Header value sent by the client must include the specified characters.
 * @property suffix Header value sent by the client must end with the specified characters.
 */
public data class GatewayRouteSpecHttp2RouteMatchHeaderMatch(
    public val exact: String? = null,
    public val prefix: String? = null,
    public val range: GatewayRouteSpecHttp2RouteMatchHeaderMatchRange? = null,
    public val regex: String? = null,
    public val suffix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttp2RouteMatchHeaderMatch): GatewayRouteSpecHttp2RouteMatchHeaderMatch = GatewayRouteSpecHttp2RouteMatchHeaderMatch(
            exact = javaType.exact().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            range = javaType.range().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttp2RouteMatchHeaderMatchRange.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regex = javaType.regex().map({ args0 -> args0 }).orElse(null),
            suffix = javaType.suffix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
