@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers Client request headers to match on.
 * @property hostname Host name to match on.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Path to match requests with. This parameter must always start with `/`, which by itself matches all requests to the virtual service name.
 * @property queryParameters Client request query parameters to match on.
 */
public data class GatewayRouteSpecHttpRouteMatch(
    public val headers: List<GatewayRouteSpecHttpRouteMatchHeader>? = null,
    public val hostname: GatewayRouteSpecHttpRouteMatchHostname? = null,
    public val path: GatewayRouteSpecHttpRouteMatchPath? = null,
    public val port: Int? = null,
    public val prefix: String? = null,
    public val queryParameters: List<GatewayRouteSpecHttpRouteMatchQueryParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GatewayRouteSpecHttpRouteMatch): GatewayRouteSpecHttpRouteMatch = GatewayRouteSpecHttpRouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttpRouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            hostname = javaType.hostname().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttpRouteMatchHostname.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttpRouteMatchPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GatewayRouteSpecHttpRouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
