@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property grpcRoutes
 * @property http2Routes
 * @property httpRoutes
 * @property priority
 */
public data class GetGatewayRouteSpec(
    public val grpcRoutes: List<GetGatewayRouteSpecGrpcRoute>,
    public val http2Routes: List<GetGatewayRouteSpecHttp2Route>,
    public val httpRoutes: List<GetGatewayRouteSpecHttpRoute>,
    public val priority: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetGatewayRouteSpec): GetGatewayRouteSpec = GetGatewayRouteSpec(
            grpcRoutes = javaType.grpcRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecGrpcRoute.Companion.toKotlin(args0)
                })
            }),
            http2Routes = javaType.http2Routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttp2Route.Companion.toKotlin(args0)
                })
            }),
            httpRoutes = javaType.httpRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttpRoute.Companion.toKotlin(args0)
                })
            }),
            priority = javaType.priority(),
        )
    }
}
