@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers
 * @property hostnames
 * @property paths
 * @property port
 * @property prefix
 * @property queryParameters
 */
public data class GetGatewayRouteSpecHttp2RouteMatch(
    public val headers: List<GetGatewayRouteSpecHttp2RouteMatchHeader>,
    public val hostnames: List<GetGatewayRouteSpecHttp2RouteMatchHostname>,
    public val paths: List<GetGatewayRouteSpecHttp2RouteMatchPath>,
    public val port: Int,
    public val prefix: String,
    public val queryParameters: List<GetGatewayRouteSpecHttp2RouteMatchQueryParameter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetGatewayRouteSpecHttp2RouteMatch): GetGatewayRouteSpecHttp2RouteMatch = GetGatewayRouteSpecHttp2RouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttp2RouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            hostnames = javaType.hostnames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttp2RouteMatchHostname.Companion.toKotlin(args0)
                })
            }),
            paths = javaType.paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttp2RouteMatchPath.Companion.toKotlin(args0)
                })
            }),
            port = javaType.port(),
            prefix = javaType.prefix(),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttp2RouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
