@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers
 * @property hostnames
 * @property paths
 * @property port
 * @property prefix
 * @property queryParameters
 */
public data class GetGatewayRouteSpecHttpRouteMatch(
    public val headers: List<GetGatewayRouteSpecHttpRouteMatchHeader>,
    public val hostnames: List<GetGatewayRouteSpecHttpRouteMatchHostname>,
    public val paths: List<GetGatewayRouteSpecHttpRouteMatchPath>,
    public val port: Int,
    public val prefix: String,
    public val queryParameters: List<GetGatewayRouteSpecHttpRouteMatchQueryParameter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetGatewayRouteSpecHttpRouteMatch): GetGatewayRouteSpecHttpRouteMatch = GetGatewayRouteSpecHttpRouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttpRouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            hostnames = javaType.hostnames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttpRouteMatchHostname.Companion.toKotlin(args0)
                })
            }),
            paths = javaType.paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttpRouteMatchPath.Companion.toKotlin(args0)
                })
            }),
            port = javaType.port(),
            prefix = javaType.prefix(),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteSpecHttpRouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
