@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property egressFilters
 * @property serviceDiscoveries
 */
public data class GetMeshSpec(
    public val egressFilters: List<GetMeshSpecEgressFilter>,
    public val serviceDiscoveries: List<GetMeshSpecServiceDiscovery>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetMeshSpec): GetMeshSpec =
            GetMeshSpec(
                egressFilters = javaType.egressFilters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetMeshSpecEgressFilter.Companion.toKotlin(args0)
                    })
                }),
                serviceDiscoveries = javaType.serviceDiscoveries().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetMeshSpecServiceDiscovery.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
