@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property grpcRoutes
 * @property http2Routes
 * @property httpRoutes
 * @property priority
 * @property tcpRoutes
 */
public data class GetRouteSpec(
    public val grpcRoutes: List<GetRouteSpecGrpcRoute>,
    public val http2Routes: List<GetRouteSpecHttp2Route>,
    public val httpRoutes: List<GetRouteSpecHttpRoute>,
    public val priority: Int,
    public val tcpRoutes: List<GetRouteSpecTcpRoute>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetRouteSpec): GetRouteSpec =
            GetRouteSpec(
                grpcRoutes = javaType.grpcRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecGrpcRoute.Companion.toKotlin(args0)
                    })
                }),
                http2Routes = javaType.http2Routes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttp2Route.Companion.toKotlin(args0)
                    })
                }),
                httpRoutes = javaType.httpRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttpRoute.Companion.toKotlin(args0)
                    })
                }),
                priority = javaType.priority(),
                tcpRoutes = javaType.tcpRoutes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecTcpRoute.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
