@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers
 * @property method
 * @property paths
 * @property port
 * @property prefix
 * @property queryParameters
 * @property scheme
 */
public data class GetRouteSpecHttp2RouteMatch(
    public val headers: List<GetRouteSpecHttp2RouteMatchHeader>,
    public val method: String,
    public val paths: List<GetRouteSpecHttp2RouteMatchPath>,
    public val port: Int,
    public val prefix: String,
    public val queryParameters: List<GetRouteSpecHttp2RouteMatchQueryParameter>,
    public val scheme: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetRouteSpecHttp2RouteMatch): GetRouteSpecHttp2RouteMatch = GetRouteSpecHttp2RouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttp2RouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            method = javaType.method(),
            paths = javaType.paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttp2RouteMatchPath.Companion.toKotlin(args0)
                })
            }),
            port = javaType.port(),
            prefix = javaType.prefix(),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttp2RouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
            scheme = javaType.scheme(),
        )
    }
}
