@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers
 * @property method
 * @property paths
 * @property port
 * @property prefix
 * @property queryParameters
 * @property scheme
 */
public data class GetRouteSpecHttpRouteMatch(
    public val headers: List<GetRouteSpecHttpRouteMatchHeader>,
    public val method: String,
    public val paths: List<GetRouteSpecHttpRouteMatchPath>,
    public val port: Int,
    public val prefix: String,
    public val queryParameters: List<GetRouteSpecHttpRouteMatchQueryParameter>,
    public val scheme: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetRouteSpecHttpRouteMatch): GetRouteSpecHttpRouteMatch = GetRouteSpecHttpRouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttpRouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            method = javaType.method(),
            paths = javaType.paths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttpRouteMatchPath.Companion.toKotlin(args0)
                })
            }),
            port = javaType.port(),
            prefix = javaType.prefix(),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetRouteSpecHttpRouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
            scheme = javaType.scheme(),
        )
    }
}
