@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionPools
 * @property healthChecks
 * @property portMappings
 * @property tls
 */
public data class GetVirtualGatewaySpecListener(
    public val connectionPools: List<GetVirtualGatewaySpecListenerConnectionPool>,
    public val healthChecks: List<GetVirtualGatewaySpecListenerHealthCheck>,
    public val portMappings: List<GetVirtualGatewaySpecListenerPortMapping>,
    public val tls: List<GetVirtualGatewaySpecListenerTl>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualGatewaySpecListener): GetVirtualGatewaySpecListener = GetVirtualGatewaySpecListener(
            connectionPools = javaType.connectionPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecListenerConnectionPool.Companion.toKotlin(args0)
                })
            }),
            healthChecks = javaType.healthChecks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecListenerHealthCheck.Companion.toKotlin(args0)
                })
            }),
            portMappings = javaType.portMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecListenerPortMapping.Companion.toKotlin(args0)
                })
            }),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewaySpecListenerTl.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
