@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property grpcs
 * @property http2s
 * @property https
 * @property tcps
 */
public data class GetVirtualNodeSpecListenerTimeout(
    public val grpcs: List<GetVirtualNodeSpecListenerTimeoutGrpc>,
    public val http2s: List<GetVirtualNodeSpecListenerTimeoutHttp2>,
    public val https: List<GetVirtualNodeSpecListenerTimeoutHttp>,
    public val tcps: List<GetVirtualNodeSpecListenerTimeoutTcp>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.GetVirtualNodeSpecListenerTimeout): GetVirtualNodeSpecListenerTimeout = GetVirtualNodeSpecListenerTimeout(
            grpcs = javaType.grpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTimeoutGrpc.Companion.toKotlin(args0)
                })
            }),
            http2s = javaType.http2s().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTimeoutHttp2.Companion.toKotlin(args0)
                })
            }),
            https = javaType.https().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTimeoutHttp.Companion.toKotlin(args0)
                })
            }),
            tcps = javaType.tcps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeSpecListenerTimeoutTcp.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
