@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property egressFilter Egress filter rules for the service mesh.
 * @property serviceDiscovery The service discovery information for the service mesh.
 */
public data class MeshSpec(
    public val egressFilter: MeshSpecEgressFilter? = null,
    public val serviceDiscovery: MeshSpecServiceDiscovery? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.MeshSpec): MeshSpec = MeshSpec(
            egressFilter = javaType.egressFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.MeshSpecEgressFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceDiscovery = javaType.serviceDiscovery().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.MeshSpecServiceDiscovery.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
