@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property grpcRoute GRPC routing information for the route.
 * @property http2Route HTTP/2 routing information for the route.
 * @property httpRoute HTTP routing information for the route.
 * @property priority Priority for the route, between `0` and `1000`.
 * Routes are matched based on the specified value, where `0` is the highest priority.
 * @property tcpRoute TCP routing information for the route.
 */
public data class RouteSpec(
    public val grpcRoute: RouteSpecGrpcRoute? = null,
    public val http2Route: RouteSpecHttp2Route? = null,
    public val httpRoute: RouteSpecHttpRoute? = null,
    public val priority: Int? = null,
    public val tcpRoute: RouteSpecTcpRoute? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpec): RouteSpec = RouteSpec(
            grpcRoute = javaType.grpcRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRoute.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http2Route = javaType.http2Route().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2Route.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpRoute = javaType.httpRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRoute.Companion.toKotlin(args0)
                })
            }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            tcpRoute = javaType.tcpRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecTcpRoute.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
