@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property metadatas Data to match from the gRPC request.
 * @property methodName Method name to match from the request. If you specify a name, you must also specify a `service_name`.
 * @property port The port number to match from the request.
 * @property prefix
 * @property serviceName Fully qualified domain name for the service to match from the request.
 */
public data class RouteSpecGrpcRouteMatch(
    public val metadatas: List<RouteSpecGrpcRouteMatchMetadata>? = null,
    public val methodName: String? = null,
    public val port: Int? = null,
    public val prefix: String? = null,
    public val serviceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRouteMatch): RouteSpecGrpcRouteMatch = RouteSpecGrpcRouteMatch(
            metadatas = javaType.metadatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteMatchMetadata.Companion.toKotlin(args0)
                })
            }),
            methodName = javaType.methodName().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
