@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property exact Value sent by the client must match the specified value exactly. Must be between 1 and 255 characters in length.
 * @property prefix Value sent by the client must begin with the specified characters. Must be between 1 and 255 characters in length.
 * @property range Object that specifies the range of numbers that the value sent by the client must be included in.
 * @property regex Value sent by the client must include the specified characters. Must be between 1 and 255 characters in length.
 * @property suffix Value sent by the client must end with the specified characters. Must be between 1 and 255 characters in length.
 */
public data class RouteSpecGrpcRouteMatchMetadataMatch(
    public val exact: String? = null,
    public val prefix: String? = null,
    public val range: RouteSpecGrpcRouteMatchMetadataMatchRange? = null,
    public val regex: String? = null,
    public val suffix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecGrpcRouteMatchMetadataMatch): RouteSpecGrpcRouteMatchMetadataMatch = RouteSpecGrpcRouteMatchMetadataMatch(
            exact = javaType.exact().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            range = javaType.range().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecGrpcRouteMatchMetadataMatchRange.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regex = javaType.regex().map({ args0 -> args0 }).orElse(null),
            suffix = javaType.suffix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
