@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an HTTP request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecHttp2Route(
    public val action: RouteSpecHttp2RouteAction,
    public val match: RouteSpecHttp2RouteMatch,
    public val retryPolicy: RouteSpecHttp2RouteRetryPolicy? = null,
    public val timeout: RouteSpecHttp2RouteTimeout? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttp2Route): RouteSpecHttp2Route = RouteSpecHttp2Route(
            action = javaType.action().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteAction.Companion.toKotlin(args0)
            }),
            match = javaType.match().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteMatch.Companion.toKotlin(args0)
            }),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteRetryPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeout = javaType.timeout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttp2RouteTimeout.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
